/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.interpreter.phpIni;

import com.aptana.php.debug.core.includepath.PHPIncludePathUtils;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org2.eclipse.php.internal.core.util.PHPSearchEngine;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.INIFileModifier;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIUtil;

public class PHPINIDebuggerUtil {
    private static final String PHP_INI_FILE = "php.ini";
    private static final String INCLUDE_PATH = "include_path";
    private static final String ZEND_EXTENSION = "zend_extension";
    private static final String ZEND_EXTENSION_TS = "zend_extension_ts";
    private static final String EXTENSIONS_DIR = "extension_dir";

    private static void modifyDebuggerExtensionPath(File phpIniFile, String extensionPath, boolean isXdebug) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            if (isXdebug) {
                if ("win32".equals(Platform.getOS())) {
                    if (m.removeAllEntries(ZEND_EXTENSION_TS, Pattern.quote("..\\php_xdebug\\php_xdebug.dll"))) {
                        m.addEntry(ZEND_EXTENSION_TS, extensionPath);
                    }
                } else {
                    if (m.removeAllEntries(ZEND_EXTENSION, Pattern.quote("../php_xdebug/xdebug.so"))) {
                        m.addEntry(ZEND_EXTENSION, extensionPath);
                    }
                    if (m.removeAllEntries(ZEND_EXTENSION_TS, Pattern.quote("../php_xdebug/xdebug.so"))) {
                        m.addEntry(ZEND_EXTENSION_TS, extensionPath);
                    }
                }
            } else if ("win32".equals(Platform.getOS())) {
                if (m.removeAllEntries(ZEND_EXTENSION_TS, Pattern.quote("..\\php_zend_debugger\\ZendDebugger.dll"))) {
                    m.addEntry(ZEND_EXTENSION_TS, extensionPath);
                }
            } else {
                if (m.removeAllEntries(ZEND_EXTENSION, Pattern.quote("../php_zend_debugger/ZendDebugger.so"))) {
                    m.addEntry(ZEND_EXTENSION, extensionPath);
                }
                if (m.removeAllEntries(ZEND_EXTENSION_TS, Pattern.quote("../php_zend_debugger/ZendDebugger.so"))) {
                    m.addEntry(ZEND_EXTENSION_TS, extensionPath);
                }
            }
            m.flush();
        }
        catch (IOException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    private static void modifyExtensionsDirectoryPath(File phpIniFile, String extensionsDirPath) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            if (m.removeAllEntries(EXTENSIONS_DIR)) {
                m.addEntry(EXTENSIONS_DIR, String.valueOf('\"') + extensionsDirPath + '\"');
            }
            m.flush();
        }
        catch (IOException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    public static File prepareBeforeDebug(File phpIniFile, String phpExePath, IProject project, String debuggerID) {
        File tempIniFile = PHPINIUtil.createTemporaryPHPINIFile(phpIniFile);
        if (project != null) {
            Object[] path = PHPSearchEngine.buildIncludePath(project);
            ArrayList<String> includePath = new ArrayList<String>(path.length);
            Object[] objectArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                Object pathObject = objectArray[n2];
                if (pathObject instanceof IIncludePathEntry) {
                    IIncludePathEntry entry = (IIncludePathEntry)pathObject;
                    IPath entryPath = entry.getPath();
                    if (entry.getEntryKind() == 4) {
                        entryPath = IncludePathVariableManager.instance().resolveVariablePath(entryPath.toString());
                    }
                    if (entryPath != null) {
                        includePath.add(entryPath.toFile().getAbsolutePath());
                    }
                } else if (pathObject instanceof IContainer) {
                    IContainer container = (IContainer)pathObject;
                    IPath location = container.getLocation();
                    if (location != null) {
                        includePath.add(location.toOSString());
                    }
                } else {
                    includePath.add(pathObject.toString());
                }
                ++n2;
            }
            includePath.addAll(PHPIncludePathUtils.getInterpreterIncludePath((IProject)project));
            PHPINIUtil.modifyIncludePath(tempIniFile, includePath.toArray(new String[includePath.size()]));
        }
        if (phpIniFile != null) {
            File extensionsDirectory;
            File debuggerFile;
            if ("org2.eclipse.php.debug.core.xdebugDebugger".equals(debuggerID)) {
                debuggerFile = new File(phpIniFile.getParentFile(), "win32".equals(Platform.getOS()) ? "php_xdebug.dll" : "xdebug.so");
                if (debuggerFile.exists()) {
                    PHPINIDebuggerUtil.modifyDebuggerExtensionPath(tempIniFile, String.valueOf('\"') + debuggerFile.getAbsolutePath() + '\"', true);
                }
            } else if ("org2.eclipse.php.debug.core.zendDebugger".equals(debuggerID) && (debuggerFile = new File(phpIniFile.getParentFile(), "win32".equals(Platform.getOS()) ? "ZendDebugger.dll" : "ZendDebugger.so")).exists()) {
                PHPINIDebuggerUtil.modifyDebuggerExtensionPath(tempIniFile, String.valueOf('\"') + debuggerFile.getAbsolutePath() + '\"', false);
            }
            if ((extensionsDirectory = new File(phpIniFile.getParentFile().getParentFile(), "php5/ext")).exists()) {
                PHPINIDebuggerUtil.modifyExtensionsDirectoryPath(tempIniFile, extensionsDirectory.getAbsolutePath());
            }
        }
        return tempIniFile;
    }
}

